function [out params]=SimulateDVineTC(data,t,dof)
% code to simulate a D - vine based on bivariate T copula
% INPUTS:
% data: A matrix of U(0,1) margins or a positive integer. In case you
% provide a matrix, the correlation parameters  will be equal to the sample
% parameters from data, for example the parameter of the C24|1, which is
% the partial correlation of variables 2 and 4, given 1, will be equal to
% the partial correlation of columns 2 and 4, given column 1, from the data.
% If you provide a positive integer, the theta parameters will also be
% simulated.
% t: The size of the simulated data (number of rows)
% dof: the degree of freedom parameters for the bivariate copula
% (optional). If provided it should be a column vector with N(N-1)/2 rows
% OUTPUTS:
% out: The simulated data
% params: A structure that contains the rho's and dof's used for the
% simulation.
if isscalar(data)==1
[CVine,rho]=CVineStruct(data); % create theta parameters
N=data;
else
[CVine,rho]=CVineStruct(data); % create theta parameters
N=size(data,2);
end
if nargin==2 || isempty(dof)
    dof=linspace(5,80,N*(N-1)/2)';
end
if size(dof,1)~=N*(N-1)/2 || size(dof,2)~=1
    display('the dof should be a column vector with N(N-1)/2 rows')
    display('a linearly spaced dof vector is loaded')
    dof=linspace(5,80,N*(N-1)/2)';
end
dof=crIPmat(dof);
w=rand(t,N);
out=zeros(size(w));
u=cell(N,N);
u{1,1}=w(:,1); out(:,1)=w(:,1);
u{2,1}=invhfuncTC(w(:,2),u{1,1},dof(1,1),rho{1,1});
out(:,2)=u{2,1};
u{2,2}=hfuncTC(u{1,1},u{2,1}, dof(1,1),rho{1,1});
for i=3:N
    u{i,1}=w(:,i);
    l=linspace(i-1,2,i-2); s=length(l);
    for k=1:s
        u{i,1}=invhfuncTC(u{i,1},u{i-1,2*l(k)-2},dof(l(k),i-l(k)),rho{l(k),i-l(k)});
    end
    u{i,1}=invhfuncTC(u{i,1},u{i-1,1},dof(1,i-1),rho{1,i-1});
    out(:,i)=u{i,1};
    if i<N
    u{i,2}=hfuncTC(u{i-1,1},u{i,1},dof(1,i-1),rho{1,i-1});
    u{i,3}=hfuncTC(u{i,1},u{i-1,1},dof(1,i-1),rho{1,i-1});
    if i>3
    for j=2:(i-2)
        u{i,2*j}=hfuncTC(u{i-1,2*j-2},u{i,2*j-1},dof(j,i-j),rho{j,i-j});
        u{i,2*j+1}=hfuncTC(u{i-1,2*j-1},u{i,2*j-2},dof(j,i-j),rho{j,i-j});
    end
    end
    u{i,2*i-2}=hfuncTC(u{i-1,2*i-4},u{i,2*i-3},dof(i-1,1),rho{i-1,1});
    end
end
params.rho=rho;
params.dof=dof;